-- Su-24MU by Currenthill

BD3_pylons = 
{
	"PylonBD3_1",
	"PylonBD3_2",
	"PylonBD3_3",
	"PylonBD3_4",
	"PylonBD3_5",
	"PylonBD3_6",
	"PylonBD3_7",
	"PylonBD3_8",
}
function BD3_(station,clsid)
	return {CLSID = clsid,  connector = BD3_pylons[station] , arg_value = 0 }
end

BD4_pylons = 
{
	[2] = "PylonBD4_2",
	[4] = "PylonBD4_4",
	[7] = "PylonBD4_7",
}

function BD4_(station,clsid)
	return {CLSID = clsid,  connector = BD4_pylons[station] , arg_value = 0.1 }
end

SU24MU =  {
      
		Name 			= 'CH_Su-24MU',
		DisplayName		= _('[CH] Su-24MU'),
        Picture 		= "Su-24M.png",
        Rate 			= "100",
        Shape			= "su-24mu",
        WorldID		=  WSTYPE_PLACEHOLDER,
        
	shape_table_data 	= 
	{
		{
			file  	 	= 'su-24mu';
			life  	 	= 26; -- lifebar
			vis   	 	= 3; -- visibility gain.
			desrt    	= 'b-1b-oblomok'; -- Name of destroyed object file name
			fire  	 	= { 300, 2}; -- Fire on the ground after destoyed: 300sec 2m
			username	= 'Su-24MU';
			index       =  WSTYPE_PLACEHOLDER;
			classname   = "lLandPlane";
			positioning = "BYNORMAL";
		},
		{
			name  		= "su-24-oblomok";
			file  		= "su-24-oblomok";
			fire  		= { 240, 2};
		},
	},

		-- Countermeasures
		passivCounterm = {
			CMDS_Edit = true,
			SingleChargeTotal = 192,
			-- PPR-26
			chaff = {default = 96, increment = 24, chargeSz = 1},
			-- PPI-26
			flare = {default = 96, increment = 24, chargeSz = 1}
        },
        
        attribute = {wsType_Air, wsType_Airplane, wsType_Fighter, WSTYPE_PLACEHOLDER,
        "Bombers", "Refuelable"
        },
        Categories = {
        },
        CanopyGeometry = makeAirplaneCanopyGeometry(LOOK_BAD, LOOK_BAD, LOOK_BAD),
        Sensors = {
            RADAR = "Orion-A",
            OPTIC = "Kaira-1",
            RWR = "Abstract RWR"
        },
		
		laserEquipment = { 
			laserDesignator = true,
			laserRangefinder = true
		},
		
        Countermeasures = {
            ECM = "Geran SPS-161"
        },
        mapclasskey = "P0091000027",
 	
		M_empty	=	22300,
		M_nominal	=	33325,
		M_max	=	39700,
		M_fuel_max	=	11700,
		H_max	=	17500,
		average_fuel_consumption	=	0.8937,
		CAS_min	=	70,
		V_opt	=	210,
		V_take_off	=	78,
		V_land	=	75,
		has_afteburner	=	true,
		has_speedbrake	=	true,
		
		nose_gear_pos 				= 	{ 5.599148, -2.497651, 0},
		main_gear_pos 				= 	{-2.832159, -2.450034, 1.687489},
		nose_gear_wheel_diameter	=	0.64,
		main_gear_wheel_diameter	=	0.940,
	
		nose_gear_amortizer_direct_stroke        =  0,  -- down from nose_gear_pos !!!
		nose_gear_amortizer_reversal_stroke      = -0.366912,  -- up 
		main_gear_amortizer_direct_stroke	     =  0, --  down from main_gear_pos !!!
		main_gear_amortizer_reversal_stroke      = -0.433269, --  up 
		nose_gear_amortizer_normal_weight_stroke = -0.075,-- down from nose_gear_pos
		main_gear_amortizer_normal_weight_stroke = -0.15, -- down from main_gear_pos		
		
		radar_can_see_ground	=	true,
		AOA_take_off	=	0.17,
		stores_number	=	8,
		bank_angle_max	=	60,
		Ny_min	=	-2,
		Ny_max	=	5.9,
		tand_gear_max	=	0.577,
		V_max_sea_level	=	388.9,
		V_max_h	=	472,
		tanker_type	=	4,
		wing_area	=	55.17,
		wing_span	=	17.64,
		wing_type = VARIABLE_GEOMETRY,
		thrust_sum_max	=	15600,
		thrust_sum_ab	=	22400,
		Vy_max	=	200,
		length	=	24.53,
		height	=	4.97,
		flaps_maneuver	=	1,
		Mach_max	=	1.35,
		range	=	1200,
		RCS	=	7.5,
		Ny_max_e	=	6.5,
		detection_range_max	=	0,
		IR_emission_coeff	=	1.5,
		IR_emission_coeff_ab	=	5.0,
		engines_count	=	2,
		wing_tip_pos = 	{-3,	0.413,	8.9},
		engines_nozzles = 
		{
			[1] = 
			{
				pos = 	{-9.417,	0.095,	-0.616},
				elevation	=	1.5,
				diameter	=	1.04,
				exhaust_length_ab	=	5,
				exhaust_length_ab_K	=	0.76,
				smokiness_level     = 	0.4, 
			}, -- end of [1]
			[2] = 
			{
				pos = 	{-9.417,	0.095,	0.616},
				elevation	=	1.5,
				diameter	=	1.04,
				exhaust_length_ab	=	5,
				exhaust_length_ab_K	=	0.76,
				smokiness_level     = 	0.4, 
			}, -- end of [2]
		}, -- end of engines_nozzles
		crew_members = 
		{
			[1] = 
			{
				ejection_seat_name	=	9,
				drop_canopy_name	=	"su-24-fonar-l",
                canopy_ejection_dir = {0.0, 1.0, 0.3},
                canopy_pos = {0, 0, 0},
				canopy_arg = 38, 
				pos = {4.9, 0.475, 0.305},
			}, -- end of [1]
			[2] = 
			{
				ejection_seat_name	=	9,
				drop_canopy_name	=	"su-24-fonar-r",
                canopy_ejection_dir = {0.0, 1.0, -0.3},
                canopy_pos = {0, 0, 0},
				pos = {4.9, 0.475, -0.305},
                canopy_arg = 38,
                boarding_arg = 38,
			}, -- end of [2]
		}, -- end of crew_members
		
	mechanimations = {
		Door0 = { {
				Flags = { "Reversible" },
				Sequence = { {
						C = { { "Arg", 38, "to", 0.9, "in", 9 } }
					} },
				Transition = { "Close", "Open" }
			}, {
				Flags = { "Reversible", "StepsBackwards" },
				Sequence = { {
						C = { { "Arg", 38, "to", 0, "in", 6 } }
					} },
				Transition = { "Open", "Close" }
			}, {
				Sequence = { {
						C = { { "JettisonCanopy", 0 } }
					} },
				Transition = { "Any", "Bailout" }
			} },
		Door1 = { {
				Sequence = { {
						C = { { "JettisonCanopy", 1 } }
					} },
				Transition = { "Any", "Bailout" }
			} },
		HeadLights = { {
				Sequence = { {
						C = { { "Arg", 51, "to", 0, "in", 5 } }
					} },
				Transition = { "Any", "Retract" }
			}, {
				Sequence = { {
						C = { { "Arg", 51, "to", 0, "in", 5 } }
					} },
				Transition = { "Any", "Off" }
			}, {
				Sequence = { {
						C = { { "Arg", 51, "to", 1, "in", 4 } }
					} },
				Transition = { "Any", "Taxi" }
			}, {
				Sequence = { {
						C = { { "Arg", 51, "to", 1, "in", 4 } }
					} },
				Transition = { "Any", "High" }
			} }
	},		
		
		brakeshute_name	=	4,
		air_refuel_receptacle_pos = {7.610, 1.225, 0,035},--	{9.143,	1.142,	0},
		fires_pos = 
		{
			[1] = 	{-0.936,	-0.861,	0},
			[2] = 	{-0.454,	0.556,	1.272},
			[3] = 	{-0.454,	0.556,	-1.272},
			[4] = 	{-0.82,	0.265,	2.774},
			[5] = 	{-0.82,	0.265,	-2.774},
			[6] = 	{-0.82,	0.255,	4.274},
			[7] = 	{-0.82,	0.255,	-4.274},
			[8] = 	{-8.417,	0.095,	0.616},
			[9] = 	{-8.417,	0.095,	-0.616},
			[10] = 	{-1.763,	0.193,	1.47},
			[11] = 	{-1.763,	0.193,	-1.47},
		}, -- end of fires_pos

	Guns = {
		gun_mount("GSh_23_6",
		{
			count = 500
		},
		{
			muzzle_pos_connector 	= "Gun_point_00",
			supply_position			= {0,0,0},	-- approx
			drop_cartridge          = 0,
			ejector_pos				= {-0.5, -0.5, 0},
			ejector_dir 			= {-2, -5, 0},
			effects = {gatling_effect(351, 6), fire_effect(350), smoke_effect()}
		})
	},

    		Pylons =     {
       pylon(1, 0, -3.010777,  0.033165, -4.894181,
            {
				arg 	  = 308,
				arg_value = 1,--clean be default
                connector = "PYLON_1",
				use_full_connector_position = true,
            },
            {
				{ CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}" },--R-60M
				{ CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}" },--R-73					
                { CLSID = "{F99BEC1A-869D-4AC7-9730-FBA0E3B1F5FC}" },--MER*6 FAB-100
                BD3_(1,"{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}"),--UB-32A - 32 S-5KO
                BD3_(1,"{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}"),--B-8M1 - 20 S-8KOM
                BD3_(1,"{3C612111-C7AD-476E-8A8E-2485812F4E5C}"),--FAB250
                BD3_(1,"{FC56DF80-9B09-44C5-8976-DCFAFF219062}"),--B-13L - 5 S-13 OF
                BD3_(1,"{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}"),--S-24B
                BD3_(1,"{A0648264-4BC0-4EE8-A543-D119F6BA4257}"),--S-25 OFM
                BD3_(1,"{6DADF342-D4BA-4D8A-B081-BA928C4AF86D}"),--Kh-25ML		
				{ CLSID = "{CH_AASM250}", Type = 1 },--AASM 250					
            }
        ),
        pylon(2, 0, -1.626964,  0.168190, -2.253826,
            {
				arg 	  = 309,
				arg_value = 1,--clean be default
                connector = "PYLON_2",
				
				use_full_connector_position = true,
            },
            {
                { CLSID = "{F99BEC1A-869D-4AC7-9730-FBA0E3B1F5FC}" },--MER*6 FAB-100
                { CLSID = "{B4FC81C9-B861-4E87-BBDC-A1158E648EBF}", Type = 1},--Kh-29T
                BD3_(2,"{6DADF342-D4BA-4D8A-B081-BA928C4AF86D}" ),--Kh-25ML
                BD3_(2,"{3C612111-C7AD-476E-8A8E-2485812F4E5C}" ),--FAB250
                BD3_(2,"{37DCC01E-9E02-432F-B61D-10C166CA2798}" ),--FAB-500 M62
                BD3_(2,"{E2C426E3-8B10-4E09-B733-9CDC26520F48}" ),--KAB-500kr
                BD3_(2,"{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}" ),--UB-32A - 32 S-5KO
                BD3_(2,"{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}" ),--B-8M1 - 20 S-8KOM
                BD3_(2,"{FC56DF80-9B09-44C5-8976-DCFAFF219062}" ),--B-13L - 5 S-13 OF
                BD3_(2,"{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}" ),--S-24B
                BD3_(2,"{A0648264-4BC0-4EE8-A543-D119F6BA4257}" ),--S-25 OFM
                BD4_(2, "{39821727-F6E2-45B3-B1F0-490CC8921D1E}"),--KAB-1500L
				BD4_(2,"{7D7EC917-05F6-49D4-8045-61FC587DD019}" ),--PTB
				{ CLSID = "{SU24MU_STORMSHADOW}", connector = "PylonBD3_2", arg_value = 0.0, Type = 1 },--Storm Shadow				
				{ CLSID = "{SU24MU_KEPD350}", connector = "PylonBD3_2", arg_value = 0.0, Type = 1 },--Taurus KEPD-350				
				{ CLSID = "{CH_AASM250}", Type = 1 },--AASM 250					
            }
        ),
        pylon(3, 1, -2.860757, -0.790051, -0.473607,
            {
				arg 	  = 310,
				arg_value = 1,--clean be default
                connector = "PYLON_3",
				use_full_connector_position = true,
            },
            {
                { CLSID = "{F99BEC1A-869D-4AC7-9730-FBA0E3B1F5FC}"},--MER*6 FAB-100
                BD3_(3,"{3C612111-C7AD-476E-8A8E-2485812F4E5C}" ),--FAB250
                BD3_(3,"{37DCC01E-9E02-432F-B61D-10C166CA2798}" ),--FAB-500 M62
                BD3_(3,"{E2C426E3-8B10-4E09-B733-9CDC26520F48}" ),--KAB-500kr
                BD3_(3,"{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}" ),--UB-32A - 32 S-5KO
                BD3_(3,"{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}" ),--B-8M1 - 20 S-8KOM
                BD3_(3,"{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}" ),--S-24B	
				{ CLSID = "{CH_AASM250}", Type = 1 },--AASM 250					
            }
        ),
        pylon(4, 1, -1.901574, -0.790303,  0.033709,
            {
				arg 	  = 311,
				arg_value = 1,--clean be default
                connector = "PYLON_4",
				use_full_connector_position = true,
            },
            {
                { CLSID = "{F99BEC1A-869D-4AC7-9730-FBA0E3B1F5FC}" },--mbd
                BD3_(4,"{3C612111-C7AD-476E-8A8E-2485812F4E5C}" ),--FAB250
				BD4_(4, "{39821727-F6E2-45B3-B1F0-490CC8921D1E}"),--KAB-1500L
				{ CLSID = "{CH_AASM250}", Type = 1 },--AASM 250					
            }
        ),
        pylon(5, 1,  0.881221, -0.806699,  0.033955,
            {
				arg 	  = 312,
				arg_value = 1,--clean be default
                connector = "PYLON_5",
				use_full_connector_position = true,
            },
            {
                { CLSID = "{16602053-4A12-40A2-B214-AB60D481B20E}" ,arg_value = 0, connector = "PylonBD3_5" , forbidden = {{ station = 4}} },--PTB
                { CLSID = "{0519A264-0AB6-11d6-9193-00A0249B6F00}" },--L-081 Fantasmagoria ELINT pod
                BD3_(5,"{3C612111-C7AD-476E-8A8E-2485812F4E5C}" ),--FAB250					
            }
        ),
        pylon(6, 1, -2.860757, -0.790051,  0.541705,
            {
				arg 	  = 313,
				arg_value = 1,--clean be default
                connector = "PYLON_6",
				use_full_connector_position = true,
            },
            {
                { CLSID = "{F99BEC1A-869D-4AC7-9730-FBA0E3B1F5FC}"},--MER*6 FAB-100
                BD3_(6,"{3C612111-C7AD-476E-8A8E-2485812F4E5C}" ),--FAB250
                BD3_(6,"{37DCC01E-9E02-432F-B61D-10C166CA2798}" ),--FAB-500 M62
                BD3_(6,"{E2C426E3-8B10-4E09-B733-9CDC26520F48}" ),--KAB-500kr
                BD3_(6,"{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}" ),--UB-32A - 32 S-5KO
                BD3_(6,"{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}" ),--B-8M1 - 20 S-8KOM
                BD3_(6,"{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}" ),--S-24B
				{ CLSID = "{CH_AASM250}", Type = 1 },--AASM 250					
            }
        ),
        pylon(7, 0, -1.626964,  0.168189,  2.321837,
            {
				arg 	  = 314,
				arg_value = 1,--clean be default
                connector = "PYLON_7",
				use_full_connector_position = true,
            },
            {
                { CLSID = "{F99BEC1A-869D-4AC7-9730-FBA0E3B1F5FC}" },--MER*6 FAB-100
                { CLSID = "{B4FC81C9-B861-4E87-BBDC-A1158E648EBF}", Type = 1},--Kh-29T
                BD3_(7,"{6DADF342-D4BA-4D8A-B081-BA928C4AF86D}" ),--Kh-25ML
                BD3_(7,"{3C612111-C7AD-476E-8A8E-2485812F4E5C}" ),--FAB250
                BD3_(7,"{37DCC01E-9E02-432F-B61D-10C166CA2798}" ),--FAB-500 M62
                BD3_(7,"{E2C426E3-8B10-4E09-B733-9CDC26520F48}" ),--KAB-500kr
                BD3_(7,"{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}" ),--UB-32A - 32 S-5KO
                BD3_(7,"{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}" ),--B-8M1 - 20 S-8KOM
                BD3_(7,"{FC56DF80-9B09-44C5-8976-DCFAFF219062}" ),--B-13L - 5 S-13 OF
                BD3_(7,"{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}" ),--S-24B
                BD3_(7,"{A0648264-4BC0-4EE8-A543-D119F6BA4257}" ),--S-25 OFM
                BD4_(7, "{39821727-F6E2-45B3-B1F0-490CC8921D1E}"),--KAB-1500L  
				BD4_(7,"{7D7EC917-05F6-49D4-8045-61FC587DD019}" ),--PTB				
				{ CLSID = "{SU24MU_STORMSHADOW}", connector = "PylonBD3_7", arg_value = 0.0, Type = 1 },--Storm Shadow				
				{ CLSID = "{SU24MU_KEPD350}", connector = "PylonBD3_7", arg_value = 0.0, Type = 1 },--Taurus KEPD-350	
				{ CLSID = "{CH_AASM250}", Type = 1 },--AASM 250					
			}
        ),
        pylon(8, 0, -3.010779,  0.033164,  4.962269,
            {
				arg 	  = 315,
				arg_value = 1,--clean be default
                connector = "PYLON_8",
				use_full_connector_position = true,
            },
            {
				{ CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}" },--R-60M
				{ CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}" },--R-73	
                { CLSID = "{F99BEC1A-869D-4AC7-9730-FBA0E3B1F5FC}" },--MER*6 FAB-100
                BD3_(8,"{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}"),--UB-32A - 32 S-5KO
                BD3_(8,"{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}"),--B-8M1 - 20 S-8KOM
                BD3_(8,"{3C612111-C7AD-476E-8A8E-2485812F4E5C}"),--FAB250
                BD3_(8,"{FC56DF80-9B09-44C5-8976-DCFAFF219062}"),--B-13L - 5 S-13 OF
                BD3_(8,"{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}"),--S-24B
                BD3_(8,"{A0648264-4BC0-4EE8-A543-D119F6BA4257}"),--S-25 OFM
                BD3_(8,"{6DADF342-D4BA-4D8A-B081-BA928C4AF86D}"),--Kh-25ML
				{ CLSID = "{CH_AASM250}", Type = 1 },--AASM 250					
            }
        ),
    },
	
	Tasks = {
		aircraft_task(Reconnaissance),
    	aircraft_task(GroundAttack),
     	aircraft_task(CAS),
        aircraft_task(AFAC),
	    aircraft_task(RunwayAttack),
		aircraft_task(AntishipStrike),
		aircraft_task(SEAD),
        aircraft_task(PinpointStrike),		
    },	
	DefaultTask = aircraft_task(GroundAttack),

	SFM_Data = {
		aerodynamics = 
		{
			Cy0	=	0,
			Mzalfa	=	4.355,
			Mzalfadt	=	0.8,
			kjx	=	2.7,
			kjz	=	0.00125,
			Czbe	=	-0.016,
			cx_gear	=	0.0268,
			cx_flap	=	0.05,
			cy_flap	=	0.9,
			cx_brk	=	0.0275,
			table_data = 
			{
				[1] = 	{0,	0.0235,	0.07,	0.024,	0.18,	0.5,	30,	1.1},
				[2] = 	{0.2,	0.0235,	0.07,	0.024,	0.18,	1.5,	30,	1.1},
				[3] = 	{0.4,	0.0235,	0.07,	0.024,	0.18,	2.5,	30,	1.1},
				[4] = 	{0.6,	0.0235,	0.073,	0.024,	0.18,	3.5,	30,	1.1},
				[5] = 	{0.7,	0.022,	0.076,	0.3,	0.052,	3.5,	28.666666666667,	1.0911111111111},
				[6] = 	{0.8,	0.022,	0.079,	0.3,	0.052,	3.5,	27.333333333333,	1.0822222222222},
				[7] = 	{0.9,	0.0235,	0.083,	0.324,	0.0536,	3.5,	26,	1.0733333333333},
				[8] = 	{1,	0.03,	0.085,	0.348,	0.0552,	3.5,	24.666666666667,	1.0644444444444},
				[9] = 	{1.05,	0.031,	0.0855,	0.36,	0.056,	3.5,	24,	1.06},
				[10] = 	{1.1,	0.032,	0.086,	0.372,	0.0568,	3.15,	18,	1.04},
				[11] = 	{1.2,	0.0325,	0.083,	0.396,	0.0584,	2.45,	17,	1.02},
				[12] = 	{1.3,	0.032,	0.077,	0.42,	0.06,	1.75,	16,	1},
				[13] = 	{1.5,	0.031,	0.062,	0.488571,	0.06,	1.5,	13,	0.9},
				[14] = 	{1.7,	0.03,	0.051333333333333,	0.557143,	0.06,	0.9,	12,	0.7},
				[15] = 	{1.8,	0.0295,	0.046,	0.591429,	0.06,	0.86,	11.4,	0.64},
				[16] = 	{2,	0.029,	0.039,	0.66,	0.06,	0.78,	10.2,	0.52},
				[17] = 	{2.2,	0.028,	0.034,	0.227,	3.2,	0.7,	9,	0.4},
				[18] = 	{2.5,	0.027,	0.033,	0.25,	4.5,	0.7,	9,	0.4},
				[19] = 	{3.9,	0.027,	0.033,	0.35,	6,	0.7,	9,	0.4},
			}, -- end of table_data
		}, -- end of aerodynamics
		engine = 
		{
			Nmg	=	60.00001,--67.5,
			MinRUD	=	0,
			MaxRUD	=	1,
			MaksRUD	=	0.85,
			ForsRUD	=	0.91,
			type	=	"TurboJet",
			hMaxEng	=	19,
			dcx_eng	=	0.0124,
			cemax	=	1.24,
			cefor	=	2.56,
			dpdh_m	=	10000,
			dpdh_f	=	15000,
			table_data = 
			{
				[1] = 	{0,	153000,	220000},
				[2] = 	{0.2,	149000,	224536.1},
				[3] = 	{0.4,	142000,	232000},
				[4] = 	{0.6,	147000,	237000},
				[5] = 	{0.7,	147000,	239000},
				[6] = 	{0.8,	149000,	243000},
				[7] = 	{0.9,	149000,	251000},
				[8] = 	{1,	149000,	255000},
				[9] = 	{1.1,	155000,	260000},
				[10] = 	{1.2,	160000,	264000},
				[11] = 	{1.3,	168000,	268000},
				[12] = 	{1.4,	170000,	274000},
				[13] = 	{1.596,	182000,	276000},
				[14] = 	{1.8,	195000,	276000},
				[15] = 	{2.2,	190000,	210000},
				[16] = 	{2.35,	193000,	210000},
				[17] = 	{3.9,	179424.3,	340206.2},
			}, -- end of table_data
		}, -- end of engine
	}, -- end of [12]

	Damage = { {
			args = { 150 },
			critical_damage = 3
		}, {
			args = { 147 },
			critical_damage = 3
		}, {
			args = { 65 },
			critical_damage = 2
		},
		[0] = {
			args = { 146 },
			critical_damage = 3
		},
		[11] = {
			args = { 167 },
			critical_damage = 3
		},
		[12] = {
			args = { 161 },
			critical_damage = 3
		},
		[21] = {
			args = { 221 },
			critical_damage = 3
		},
		[22] = {
			args = { 231 },
			critical_damage = 3
		},
		[23] = {
			args = { 223 },
			critical_damage = 10,
			deps_cells = { 37, 21 }
		},
		[24] = {
			args = { 213 },
			critical_damage = 10,
			deps_cells = { 38, 22 }
		},
		[37] = {
			args = { 227 },
			critical_damage = 4
		},
		[38] = {
			args = { 217 },
			critical_damage = 4
		},
		[47] = {
			args = { 235 },
			critical_damage = 3
		},
		[48] = {
			args = { 233 },
			critical_damage = 3
		},
		[53] = {
			args = { 247 },
			critical_damage = 2
		},
		[59] = {
			args = { 148 },
			critical_damage = 3
		},
		[82] = {
			args = { 152 },
			critical_damage = 4
		},
		[136] = {
			args = { 244 },
			critical_damage = 4
		},
		[137] = {
			args = { 154 },
			critical_damage = 4
		},
		[138] = {
			args = { 153 },
			critical_damage = 4
		},
		[139] = {
			args = { 151 },
			critical_damage = 4
		},
		[140] = {
			args = { 147 },
			critical_damage = 3
		},
		cell_indices = {
			COCKPIT = 3,
			ENGINE_L = 11,
			ENGINE_R = 12,
			FIN_TOP = 136,
			FLAP_L_IN = 37,
			FLAP_R_IN = 38,
			FUSELAGE_BOTTOM = 82,
			FUSELAGE_CENTR_L = 137,
			FUSELAGE_CENTR_R = 138,
			FUSELAGE_CENTR_TOP = 139,
			NOSE_BOTTOM = 59,
			NOSE_CENTER = 0,
			NOSE_LEFT_SIDE = 1,
			NOSE_RIGHT_SIDE = 2,
			NOSE_TOP_SIDE = 140,
			RUDDER = 53,
			STABILIZER_L_IN = 47,
			STABILIZER_R_IN = 48,
			WING_L_OUT = 23,
			WING_L_PART_OUT = 21,
			WING_R_OUT = 24,
			WING_R_PART_OUT = 22
		}
	},

	DamageParts = 
	{  
		[1] = "SU-24-OBLOMOK-WING-R", -- wing R
		[2] = "SU-24-OBLOMOK-WING-L", -- wing L
	},
	
	lights_data = {
		lights = {
			[3] = {
				lights = { {
						argument = 192,
						typename = "argumentlight"
					}, {
						argument = 190,
						typename = "argumentlight"
					}, {
						argument = 191,
						typename = "argumentlight"
					} },
				typename = "collection"
			}
		},
		typename = "collection"
	},

	Countries = {"Ukraine"},	
	
}

add_aircraft(SU24MU)
